/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item.weapon;

import com.renyigesai.immortalers_delight.api.PlateBaseBlock;
import com.renyigesai.immortalers_delight.block.StackedFoodBlock;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightBlocks;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.item.ImmortalersShieldItem;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class PlaceableShieldItem
extends ImmortalersShieldItem {
    public final int type;

    public PlaceableShieldItem(Item.Properties pProperties, int type) {
        super(pProperties);
        this.type = type;
    }

    public BlockState getPlaceState(Level level, BlockPos blockpos) {
        Block block1 = (Block)ImmortalersDelightBlocks.LARGE_COLUMN.get();
        if (this.type == 1 && block1 instanceof StackedFoodBlock) {
            StackedFoodBlock stackedFoodBlock = (StackedFoodBlock)block1;
            return (BlockState)stackedFoodBlock.m_49966_().m_61124_((Property)StackedFoodBlock.BITES, (Comparable)Integer.valueOf(stackedFoodBlock.getMaxBites() - stackedFoodBlock.getPileBitesPerItem()));
        }
        return Blocks.f_50016_.m_49966_();
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        PlateBaseBlock plateBaseBlock;
        BlockPos blockpos;
        Player player = pContext.m_43723_();
        Level level = pContext.m_43725_();
        BlockState blockstate = level.m_8055_(blockpos = pContext.m_8083_());
        Block block = blockstate.m_60734_();
        if (block instanceof PlateBaseBlock && (plateBaseBlock = (PlateBaseBlock)block).isEmptyPlate(blockstate)) {
            level.m_5594_(player, blockpos, SoundEvents.f_12633_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            BlockState blockstate1 = this.getPlaceState(level, blockpos);
            level.m_7731_(blockpos, blockstate1, 11);
            level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
            ItemStack itemstack = pContext.m_43722_();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos, itemstack);
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.immortalers_delight.can_place_on_plate").m_130940_(ChatFormatting.GRAY));
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + this), (Object[])new Object[0]);
            if (this.type == 1) {
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class PlaceableShieldEvents {
        public static final String DAMAGE_TAG = "immortalers_delight_bites";

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onBlockedDamage(ShieldBlockEvent event) {
            ItemStack shield;
            Item item;
            LivingEntity hurtOne = event.getEntity();
            if (!hurtOne.m_9236_().m_5776_() && !event.isCanceled() && (item = (shield = hurtOne.m_21211_()).m_41720_()) instanceof PlaceableShieldItem) {
                PlaceableShieldItem placeableShieldItem = (PlaceableShieldItem)item;
                float damage = event.getBlockedDamage();
                if (damage > 30.0f) {
                    damage = 30.0f;
                }
                if (!DifficultyModeUtil.isPowerBattleMode()) {
                    event.setBlockedDamage(30.0f);
                }
                boolean isBroken = false;
                Entity source = event.getDamageSource().m_7640_();
                if (source instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)source;
                    isBroken = PlaceableShieldEvents.willBeDisableShield(attacker, hurtOne, shield);
                }
                if (event.shieldTakesDamage()) {
                    CompoundTag tag = hurtOne.getPersistentData();
                    if (tag.m_128425_(DAMAGE_TAG, 3) && tag.m_128451_(DAMAGE_TAG) < 1) {
                        if (isBroken) {
                            PlaceableShieldEvents.onBreakShield(hurtOne, shield, placeableShieldItem.type, damage);
                        } else {
                            tag.m_128405_(DAMAGE_TAG, tag.m_128451_(DAMAGE_TAG) + 1);
                            PlaceableShieldEvents.dropSlice(hurtOne, placeableShieldItem.type, damage);
                            PlaceableShieldEvents.healUser(hurtOne, 1);
                        }
                    } else if (!tag.m_128425_(DAMAGE_TAG, 3)) {
                        if (isBroken) {
                            PlaceableShieldEvents.onBreakShield(hurtOne, shield, placeableShieldItem.type, damage);
                        } else {
                            tag.m_128405_(DAMAGE_TAG, 1);
                            PlaceableShieldEvents.dropSlice(hurtOne, placeableShieldItem.type, damage);
                            PlaceableShieldEvents.healUser(hurtOne, 1);
                        }
                    } else {
                        ServerPlayer serverPlayer;
                        tag.m_128473_(DAMAGE_TAG);
                        PlaceableShieldEvents.dropSlice(hurtOne, placeableShieldItem.type, damage);
                        PlaceableShieldEvents.healUser(hurtOne, 5);
                        if (hurtOne instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)hurtOne).m_7500_()) {
                            shield.m_41774_(1);
                        }
                    }
                }
            }
        }

        public static boolean willBeDisableShield(LivingEntity attacker, LivingEntity hurtOne, ItemStack shield) {
            return attacker.m_213824_() || attacker.m_21205_().canDisableShield(shield, hurtOne, attacker);
        }

        public static void healUser(LivingEntity hurtOne, int buffer) {
            boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
            if (!hurtOne.m_9236_().m_5776_()) {
                for (int i = 0; i < buffer; ++i) {
                    if (hurtOne instanceof Player) {
                        Player player = (Player)hurtOne;
                        if (isPowerful) {
                            player.m_36324_().m_38707_(2, 1.0f);
                            continue;
                        }
                        player.m_36324_().m_38707_(1, 1.0f);
                        continue;
                    }
                    hurtOne.m_5634_(isPowerful ? 8.0f : 2.0f);
                }
            }
        }

        public static void onBreakShield(LivingEntity hurtOne, ItemStack stack, int type, float damage) {
            Level level = hurtOne.m_9236_();
            if (!level.m_5776_()) {
                int i = 2;
                CompoundTag tag = hurtOne.getPersistentData();
                if (tag.m_128425_(DAMAGE_TAG, 3) && tag.m_128451_(DAMAGE_TAG) > 0) {
                    i -= tag.m_128451_(DAMAGE_TAG);
                }
                for (int j = 0; j < i; ++j) {
                    PlaceableShieldEvents.dropSlice(hurtOne, type, damage);
                }
                PlaceableShieldEvents.healUser(hurtOne, 5);
                stack.m_41774_(1);
                tag.m_128473_(DAMAGE_TAG);
            }
        }

        public static void dropSlice(LivingEntity living, int type, float damage) {
            Direction direction = living.m_6350_().m_122424_();
            Level level = living.m_9236_();
            BlockPos pos = living.m_20183_();
            if (level.m_5776_() || level.f_46441_.m_188501_() * 30.0f < damage) {
                return;
            }
            if (type == 1) {
                ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)ImmortalersDelightItems.LARGE_COLUMN_SLICE.get()), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
            }
        }
    }
}

